
unit mainform;

interface

uses
  Windows, Messages, Forms, Dialogs, Spin,
  SysUtils, IdTelnet, Gauges, IniFiles, Animate, GIFCtrl, ExtCtrls,
  IdComponent, IdTCPConnection, IdTCPClient, IdBaseComponent, Controls,
  ComCtrls, StdCtrls, Classes, ShellAPI,Graphics;

type
  TfrmTelnetDemo = class(TForm)
    edtServer: TEdit;
    lblServer: TLabel;
    spnedtPort: TSpinEdit;
    lblPort: TLabel;
    IdTelnetDemo: TIdTelnet;
    Envoyer: TButton;
    Timer: TTimer;
    OpenDialog: TOpenDialog;
    Gauge: TGauge;
    StatusBar: TStatusBar;
    ComboBoxTE: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    RxGIFAnimator: TRxGIFAnimator;
    LabelLien: TLabel;
    procedure IdTelnetDemoDataAvailable(Sender: TIdTelnet;
      const Str: String);
    procedure EnvoyerClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure LabelLienClick(Sender: TObject);
    procedure LabelLienMouseEnter(Sender: TObject);
    procedure LabelLienMouseLeave(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTelnetDemo: TfrmTelnetDemo;
  buffer: string;
  FlagTimer:boolean;

implementation

{$R *.DFM}

procedure TfrmTelnetDemo.IdTelnetDemoDataAvailable(Sender: TIdTelnet;
  const Str: String);
begin
Buffer:=Buffer+Str;
end;


procedure TfrmTelnetDemo.EnvoyerClick(Sender: TObject);
var
 f:TextFile;
 r:byte;
 i,pourcent,CapaMem,TailleStr:integer;
 FlagEchec:boolean;
 caractere:char;
 str:string;
begin

  IDTelnetDemo.Host := edtServer.Text;
  IDTelnetDemo.port := spnedtPort.Value;

 //Ouverture boite de dialogue pour slection du fichier  transmettre
  if OpenDialog.Execute then
    with OpenDialog.Files do
      for i:= 0 to Count - 1 do
      begin
        AssignFile(f, Strings[i]);  { fichier suivant dans la proprit Files }
        //Lecture du fichier HTML
        {$I-} Reset(f); {SI+}
        r:=IOResult;
        If r=0 then begin
        while not Eof (f) do
        begin
          read(f,caractere);
          if (caractere<>#13) AND (caractere<>#10) then Str:=Str+caractere;
        end;
        CloseFile(f);
        Str:=Str + #0; { sparateur de fichier }
      end;
    end;

 // Caractre qui signale la fin de la transmission au PicBasic
 Str:=Str + #26; { fin de fichier }

 // Capacit de l'eeprom en octets
 CapaMem:=StrToInt(ComboBoxTE.Text)*1024;

 TailleStr:=length(Str);

 if (TailleStr<=1) Then exit;

 if (TailleStr>CapaMem) then
 begin
  ShowMessage('ATTENTION :'+#13+#13+'Taille fichier(s) > capacit eeprom');
  exit;
 end;
 Gauge.MaxValue:=length(Str);

 //Ouverture socket
 if IdTelnetDemo.Connected=false then IdTelnetDemo.Connect;

 RxGIFAnimator.Animate:=true;

 //signale au PicBasic l'envoi de la page HTML
 IdTelnetDemo.Write('PRG' + #13);
 sleep(100);

 //Transmission du fichier HTML au PicBasic
 for i:=1 to length(Str) do
 begin
  //Envoi 1 caractere du fichier
   StatusBar.Panels[1].Text:='Transfert en cours...';
   IdTelnetDemo.SendCh(Str[i]);
   StatusBar.Panels[0].Text:='Tx : '+inttostr(i)+'/'+IntToStr(TailleStr);
   FlagEchec:=false;
   FlagTimer:=false;
   Timer.Enabled:=true;
   while ( Str[i]<>buffer ) and ( FlagTimer=false ) do
   begin
     Application.ProcessMessages;
   end;
   if FlagTimer then
   begin
     ShowMessage('Echec lors de la transmission');
     FlagEchec:=true;
     break;
   end;
   buffer:='';
   Timer.Enabled:=false;
   Gauge.Progress:=Gauge.Progress+1;
 end;

 RxGIFAnimator.Animate:=false;

 //Fermeture socket
 if IdTelnetDemo.Connected then IdTelnetDemo.Disconnect;

 pourcent:=round( ( TailleStr*100 ) / CapaMem );
 if FlagEchec=false then
    ShowMessage('Transmission russie, '+inttostr( TailleStr )+' caractres programms en eeprom.'+#13
                +inttostr(pourcent)+'% de la mmoire occupe.');

 StatusBar.Panels[1].Text:='';
 Gauge.Progress:=0;

end;


procedure TfrmTelnetDemo.TimerTimer(Sender: TObject);
begin
 FlagTimer:=True;
end;

procedure TfrmTelnetDemo.FormCreate(Sender: TObject);
var FichierIni : TIniFile;
begin
 FichierIni:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Parametrage.ini');
 edtServer.Text:=FichierIni.ReadString('TELNET','IP','192.168.0.3');
 spnedtPort.Value:=StrToInt(FichierIni.ReadString('TELNET','PORT','80'));
 ComboBoxTE.text:=FichierIni.ReadString('TELNET','CAPAMEM','4');
 FichierIni.Free;
end;

procedure TfrmTelnetDemo.FormClose(Sender: TObject;
  var Action: TCloseAction);
var FichierIni : TIniFile;
begin
 FichierIni:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'Parametrage.ini');
 FichierIni.WriteString('TELNET','IP',edtServer.Text);
 FichierIni.WriteString('TELNET','PORT',IntToStr(spnedtPort.Value));
 FichierIni.WriteString('TELNET','CAPAMEM',ComboBoxTE.text);
 FichierIni.Free;
end;

procedure TfrmTelnetDemo.LabelLienClick(Sender: TObject);
begin
ShellExecute(GetDesktopWindow,'open',PChar('http://www.rdelectronique.com/'),nil,nil,SW_SHOWNORMAL);
end;

procedure TfrmTelnetDemo.LabelLienMouseEnter(Sender: TObject);
begin
LabelLien.Font.Color:=clRed;
end;

procedure TfrmTelnetDemo.LabelLienMouseLeave(Sender: TObject);
begin
LabelLien.Font.Color:=clBlue;
end;

End.
